﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.Utilities;

namespace AZVIC.Ei8htPOS.DAL
{
    public class AuditTrailDB
    {
        public static AuditTrail GetItem(Guid auditTrailID, Guid referenceID)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@AuditTrailID", ((auditTrailID != Guid.Empty && auditTrailID != null) ? auditTrailID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@ReferenceID", ((referenceID != Guid.Empty && referenceID != null) ? referenceID : (object)DBNull.Value)));

            return SQLHelper.RetrieveObject<AuditTrail>("spGetAuditTrail", parameters);
        }

        public static List<AuditTrail> GetList(Guid auditTrailID, Guid referenceID)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@AuditTrailID", ((auditTrailID != Guid.Empty && auditTrailID != null) ? auditTrailID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@ReferenceID", ((referenceID != Guid.Empty && referenceID != null) ? referenceID : (object)DBNull.Value)));

            return SQLHelper.RetrieveList<AuditTrail>("spGetAuditTrail", parameters);
        }

        public static DataTable GetDataTable(Guid auditTrailID, Guid referenceID)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@AuditTrailID", ((auditTrailID != Guid.Empty && auditTrailID != null) ? auditTrailID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@ReferenceID", ((referenceID != Guid.Empty && referenceID != null) ? referenceID : (object)DBNull.Value)));

            return SQLHelper.ExecuteDataTable("spGetAuditTrail", parameters);
        }

        public static DataSet GetDataSet(Guid auditTrailID, Guid referenceID)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@AuditTrailID", ((auditTrailID != Guid.Empty && auditTrailID != null) ? auditTrailID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@ReferenceID", ((referenceID != Guid.Empty && referenceID != null) ? referenceID : (object)DBNull.Value)));

            return SQLHelper.ExecuteDataSet("spGetAuditTrail", parameters);
        }

        public static void Save(AuditTrail myAuditTrail)
        {
            myAuditTrail.Mode = ((myAuditTrail.UniqueID != Guid.Empty && myAuditTrail.UniqueID != null) ? GlobalConfigurations.Mode.Update : GlobalConfigurations.Mode.Insert);
            myAuditTrail.UniqueID = ((myAuditTrail.UniqueID != Guid.Empty && myAuditTrail.UniqueID != null) ? myAuditTrail.UniqueID : Guid.NewGuid());
            if (myAuditTrail.Mode == GlobalConfigurations.Mode.Insert)
            {
                myAuditTrail.IsActive = true;
            }

            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@AuditTrailID", myAuditTrail.UniqueID));
            parameters.Add(new SqlParameter("@ReferenceID", ((myAuditTrail.ReferenceID != Guid.Empty && myAuditTrail.ReferenceID != null) ? myAuditTrail.ReferenceID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@IPAddress", (string.IsNullOrEmpty(myAuditTrail.IPAddress) ? (object)DBNull.Value : myAuditTrail.IPAddress)));
            parameters.Add(new SqlParameter("@Remarks", (string.IsNullOrEmpty(myAuditTrail.Remarks) ? (object)DBNull.Value : myAuditTrail.Remarks)));
            parameters.Add(new SqlParameter("@UserAccountID", ((myAuditTrail.UserAccountID != Guid.Empty && myAuditTrail.UserAccountID != null) ? myAuditTrail.UserAccountID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@AdminUserAccountID", ((myAuditTrail.AdminUserAccountID != Guid.Empty && myAuditTrail.AdminUserAccountID != null) ? myAuditTrail.AdminUserAccountID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@IsActive", myAuditTrail.IsActive));
            //parameters.Add(new SqlParameter("@IsDeleted", myProductCategory.IsDeleted));

            SQLHelper.ExecuteQuery("spAddOrUpdateAuditTrail", parameters);
        }
    }
}
